% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.

%
% (ch10p3) Example 10.8: We can use MATLAB to find gain margin(Gm), phase 
% margin(Pm), the gain-margin frequency, where the phase plot goes through 
% 180 degrees(Wcg), and the phase-margin frequency, where the magnitude 
% plot goes through 0 dB(Wcp) To find these quantities we use 
% [Gm,Pm,Wcg,Wcp] = margin(G), where G(s) = numg/deng and G is an LTI 
% transfer-function object. Let us look at Example 10.8 in the text.

'(ch10p3) Example 10.8'             % Display label.
clf                                 % Clear graph.
numg=6;                             % Define numerator of G(s).
deng=conv([1 2],[1 2 2]);           % Define denominator of G(s).
'G(s)'                              % Display label.
G=tf(numg,deng)                     % Create and display G(s).
nyquist(G)                          % Make a Nyquist diagram.
grid on                             % Turn on grid for the Nyquist diagram.
title('Open-Loop Frequency Response') 		
                                    % Add a title to the Nyquist diagram.
[Gm,Pm,Wcg,Wcp]=margin(G);          % Find margins and margin 
                                    % frequencies.
'GM(dB); PM(deg.); 180 deg. freq.(r/s); 0 dB freq.(r/s)' 
                                    % Display label.
margins=[20*log10(Gm),Pm,Wcg,Wcp]   % Display margin data.
